/*
 * Decompiled with CFR 0.152.
 */
package >org.mule.modules.edi.base.1.2.2.lib;

import com.mulesoft.flatfile.1.2.3.lib.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.1.2.3.lib.schema.EdiSchema;
import com.mulesoft.flatfile.1.2.3.lib.schema.EdiSchema$UnusedUsage$;
import com.mulesoft.flatfile.1.2.3.lib.schema.SchemaJavaValues;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.datatype.DataType;
import scala.collection.Iterator;
import scala.collection.convert.WrapAsJava$;

public abstract class EdiMetaDataBuilder {
    private static final Map<TypeFormatConstants.GenericType, DataType> typeConvert = new HashMap<TypeFormatConstants.GenericType, DataType>();
    protected final EdiSchema schema;

    public EdiMetaDataBuilder(EdiSchema schema) {
        this.schema = schema;
    }

    public void buildStructures(DynamicObjectBuilder<?> root, String structKey, boolean read2) {
        DynamicObjectFieldBuilder structuresMap = root.addDynamicObjectField(structKey);
        Iterator keys = this.schema.structures().keysIterator();
        while (!keys.isEmpty()) {
            EdiSchema.Structure structure = (EdiSchema.Structure)this.schema.structures().apply(keys.next());
            DynamicObjectBuilder tranMap = structuresMap.addList(structure.ident()).ofDynamicObject(structure.ident());
            this.buildStructure(structure, read2, tranMap);
        }
    }

    protected abstract void buildStructure(EdiSchema.Structure var1, boolean var2, DynamicObjectBuilder<?> var3);

    protected void buildStructureDetails(EdiSchema.Structure structure, DynamicObjectBuilder<?> container) {
        container.addSimpleField(SchemaJavaValues.structureId(), DataType.STRING);
        container.addSimpleField(SchemaJavaValues.structureName(), DataType.STRING);
        List comps = Collections.EMPTY_LIST;
        if (structure.heading().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList(((EdiSchema.StructureSequence)structure.heading().get()).items());
        }
        this.buildComps(comps, SchemaJavaValues.structureHeading(), false, container);
        comps = Collections.EMPTY_LIST;
        if (structure.detail().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList(((EdiSchema.StructureSequence)structure.detail().get()).items());
        }
        this.buildComps(comps, SchemaJavaValues.structureDetail(), false, container);
        comps = Collections.EMPTY_LIST;
        if (structure.summary().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList(((EdiSchema.StructureSequence)structure.summary().get()).items());
        }
        this.buildComps(comps, SchemaJavaValues.structureSummary(), false, container);
    }

    protected void buildComps(List<EdiSchema.StructureComponent> comps, String key, boolean repeat, DynamicObjectBuilder<?> parent) {
        Object wrapper = repeat ? parent.addList(key).ofDynamicObject(key) : parent.addDynamicObjectField(key);
        for (EdiSchema.StructureComponent comp : comps) {
            if (comp.usage() == EdiSchema$UnusedUsage$.MODULE$) continue;
            if (comp instanceof EdiSchema.ReferenceComponent) {
                if (this.schema.ediVersion().ediForm().isEnvelopeSegment(((EdiSchema.ReferenceComponent)comp).segment().ident())) continue;
                this.buildSegment((EdiSchema.ReferenceComponent)comp, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            if (comp instanceof EdiSchema.LoopWrapperComponent) {
                EdiSchema.LoopWrapperComponent wrapComp = (EdiSchema.LoopWrapperComponent)comp;
                this.buildComps(WrapAsJava$.MODULE$.seqAsJavaList(wrapComp.wrapped().seq().items()), wrapComp.wrapped().key(), wrapComp.count() != 1, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            if (comp instanceof EdiSchema.GroupComponent) {
                EdiSchema.GroupComponent groupComp = (EdiSchema.GroupComponent)comp;
                this.buildComps(WrapAsJava$.MODULE$.seqAsJavaList(groupComp.seq().items()), groupComp.key(), groupComp.count() != 1, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            throw new IllegalStateException("Structure component of unknown type");
        }
    }

    protected void buildSegment(EdiSchema.ReferenceComponent ref, DynamicObjectBuilder<?> parent) {
        EdiSchema.Segment segment = ref.segment();
        Object container = ref.count() != 1 ? parent.addList(ref.key()).ofDynamicObject(segment.name()) : parent.addDynamicObjectField(ref.key());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(segment.components()), (DynamicObjectBuilder<?>)container);
    }

    protected void buildSegmentComps(List<EdiSchema.SegmentComponent> comps, DynamicObjectBuilder<?> parent) {
        for (EdiSchema.SegmentComponent comp : comps) {
            if (comp instanceof EdiSchema.ElementComponent) {
                EdiSchema.Element element = ((EdiSchema.ElementComponent)comp).element();
                DataType dataType = typeConvert.get((Object)element.typeFormat().genericType());
                parent.addSimpleField(comp.key(), dataType).setLabel(comp.key() + " - " + comp.name());
                continue;
            }
            if (comp instanceof EdiSchema.CompositeComponent) {
                EdiSchema.Composite composite = ((EdiSchema.CompositeComponent)comp).composite();
                if (comp.count() == 1) {
                    this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(composite.components()), parent);
                    continue;
                }
                DynamicObjectBuilder wrapper = parent.addList(comp.key()).ofDynamicObject(comp.name() + " : " + composite.ident());
                this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(composite.components()), wrapper);
                continue;
            }
            throw new IllegalStateException("Segment component of unknown type");
        }
    }

    static {
        typeConvert.put(TypeFormatConstants.GenericType.STRING, DataType.STRING);
        typeConvert.put(TypeFormatConstants.GenericType.INTEGER, DataType.INTEGER);
        typeConvert.put(TypeFormatConstants.GenericType.REAL, DataType.DECIMAL);
        typeConvert.put(TypeFormatConstants.GenericType.DATE, DataType.DATE);
        typeConvert.put(TypeFormatConstants.GenericType.DATETIME, DataType.DATE_TIME);
        typeConvert.put(TypeFormatConstants.GenericType.BOOLEAN, DataType.BOOLEAN);
    }
}

